/*
 * Decompiled with CFR 0.152.
 */
package technology.rocketjump.undermount.mapgen.generators;

import com.badlogic.gdx.math.GridPoint2;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import technology.rocketjump.undermount.mapgen.calculators.RegionCalculator;
import technology.rocketjump.undermount.mapgen.generators.CellularAutomata;
import technology.rocketjump.undermount.mapgen.generators.MidpointDisplacement;
import technology.rocketjump.undermount.mapgen.generators.OreVeinGenerator;
import technology.rocketjump.undermount.mapgen.generators.RiverGenerator;
import technology.rocketjump.undermount.mapgen.generators.RockTypeGenerator;
import technology.rocketjump.undermount.mapgen.generators.ShrubPlanter;
import technology.rocketjump.undermount.mapgen.generators.SimplexNoise;
import technology.rocketjump.undermount.mapgen.generators.TreePlanter;
import technology.rocketjump.undermount.mapgen.model.AbstractGameMap;
import technology.rocketjump.undermount.mapgen.model.BinaryGrid;
import technology.rocketjump.undermount.mapgen.model.HeightGameMap;
import technology.rocketjump.undermount.mapgen.model.TileType;
import technology.rocketjump.undermount.mapgen.model.VertexGameMap;
import technology.rocketjump.undermount.mapgen.model.input.GameMapGenerationParams;
import technology.rocketjump.undermount.mapgen.model.input.GemType;
import technology.rocketjump.undermount.mapgen.model.input.OreType;
import technology.rocketjump.undermount.mapgen.model.output.GameMap;
import technology.rocketjump.undermount.mapgen.model.output.GameMapTile;
import technology.rocketjump.undermount.mapgen.model.output.MapRegion;
import technology.rocketjump.undermount.mapgen.model.output.TileSubType;

public class GameMapGenerator {
    private final MidpointDisplacement midpointDisplacement = new MidpointDisplacement();
    private final CellularAutomata cellularAutomata = new CellularAutomata();
    private final OreVeinGenerator oreVeinGenerator = new OreVeinGenerator();
    private final RegionCalculator regionCalculator = new RegionCalculator();
    private final TreePlanter treePlanter = new TreePlanter();
    private final ShrubPlanter shrubPlanter = new ShrubPlanter();
    private final RiverGenerator riverGenerator = new RiverGenerator();
    private final RockTypeGenerator rockTypeGenerator = new RockTypeGenerator();
    private final Random random;
    private final GameMapGenerationParams generationParams;
    private boolean finished = false;
    private VertexGameMap vertexMap;
    private HeightGameMap heightMap;
    private float heightmapVariance;
    private GameMap gameMap;
    private int gameMapIterations;
    private float desiredHeightForMountains = -1.0f;
    private int totalMapSize;
    private int amountOreRequired;
    private int amountOreGenerated;
    private int amountGemsRequired;
    private int amountGemsGenerated;
    private List<MapRegion> largeMountainRegions;
    private int totalMountainTiles;

    public GameMapGenerator(GameMapGenerationParams generationParams, Random random) {
        this.random = random;
        this.generationParams = generationParams;
        this.vertexMap = new VertexGameMap(1, 1);
        this.heightmapVariance = generationParams.getHeightMapVariance();
        this.vertexMap.set(0, 0, MidpointDisplacement.vary(0.0f, this.heightmapVariance, random));
        this.vertexMap.set(0, 1, MidpointDisplacement.vary(0.0f, this.heightmapVariance, random));
        this.vertexMap.set(1, 0, MidpointDisplacement.vary(0.0f, this.heightmapVariance, random));
        this.vertexMap.set(1, 1, MidpointDisplacement.vary(0.0f, this.heightmapVariance, random));
    }

    public GameMap completeGeneration() {
        while (!this.finished) {
            this.processNextStep();
        }
        return this.gameMap;
    }

    public void processNextStep() {
        if (this.gameMap != null) {
            this.processGameMapStep();
        } else if (this.heightMap != null) {
            this.processHeightMapStep();
        } else {
            this.processVertexMapStep();
        }
    }

    private void processGameMapStep() {
        if (this.gameMapIterations < 5) {
            GameMap updated;
            this.gameMap = updated = this.cellularAutomata.smoothWalls(this.gameMap);
        } else if (this.gameMapIterations == 5) {
            this.gameMap.randomiseCaves(this.random);
        } else if (this.gameMapIterations < 11) {
            this.gameMap = this.cellularAutomata.smoothCaves(this.gameMap);
        } else if (this.gameMapIterations < 15) {
            this.gameMap = this.cellularAutomata.smoothOutdoorSubregions(this.gameMap);
        } else if (this.gameMapIterations == 15) {
            this.rockTypeGenerator.assignRockGroups(this.gameMap, this.random);
        } else if (this.gameMapIterations <= 19) {
            this.gameMap = this.cellularAutomata.smoothRockTypes(this.gameMap);
        } else if (this.gameMapIterations == 20) {
            this.regionCalculator.assignRegions(this.gameMap);
        } else if (this.gameMapIterations == 21) {
            this.regionCalculator.assignSubRegions(this.gameMap);
        } else if (this.gameMapIterations == 22) {
            this.rockTypeGenerator.assignRockTypes(this.gameMap, this.generationParams, this.random);
        } else if (this.gameMapIterations == 23) {
            this.riverGenerator.addRiver(this.gameMap, this.random);
        } else if (this.gameMapIterations <= 25) {
            this.cellularAutomata.growRiver(this.gameMap);
        } else if (this.gameMapIterations == 26) {
            this.riverGenerator.ensureRiverEndpoints(this.gameMap, 5);
            this.treePlanter.placeTrees(this.gameMap, TileSubType.FOREST, this.random, this.generationParams);
        } else if (this.gameMapIterations == 27) {
            this.shrubPlanter.placeShrubs(this.gameMap, TileSubType.GRASSLAND, this.random, this.generationParams);
        } else if (this.gameMapIterations == 28) {
            this.initialiseOreGeneration();
            this.generateOre();
            this.generateOre();
            this.generateOre();
        } else if (this.amountOreGenerated < this.amountOreRequired) {
            this.generateOre();
            this.generateOre();
            this.generateOre();
        } else if (this.amountGemsGenerated < this.amountGemsRequired) {
            this.generateGems();
            this.generateGems();
            this.generateGems();
        } else {
            this.finished = true;
        }
        ++this.gameMapIterations;
    }

    private void processHeightMapStep() {
        if (this.heightMap.getWidth() > this.generationParams.getTargetWidth() || this.heightMap.getHeight() > this.generationParams.getTargetHeight()) {
            int extraWidth = this.heightMap.getWidth() - this.generationParams.getTargetWidth();
            int extraHeight = this.heightMap.getHeight() - this.generationParams.getTargetHeight();
            int offsetX = extraWidth / 2;
            int offsetY = extraHeight / 2;
            this.heightMap = this.heightMap.crop(offsetX, offsetY, this.generationParams.getTargetWidth(), this.generationParams.getTargetHeight());
            this.vertexMap = this.vertexMap.crop(offsetX, offsetY, this.generationParams.getTargetWidth(), this.generationParams.getTargetHeight());
        } else if (this.desiredHeightForMountains < 0.0f) {
            this.desiredHeightForMountains = this.heightMap.heightForRatioAbove(this.generationParams.getRatioOfMountains());
        } else {
            this.gameMap = this.heightMap.toGameMap(this.desiredHeightForMountains);
            int largestFeature = Math.min(this.generationParams.getTargetWidth(), this.generationParams.getTargetHeight());
            SimplexNoise simplexNoise = new SimplexNoise(largestFeature, 0.6, this.random);
            this.gameMap.addSimplexNoise(simplexNoise);
            this.gameMap.setVertexGameMap(this.vertexMap);
        }
    }

    private void processVertexMapStep() {
        if (this.vertexMap.getNumTilesWide() <= this.generationParams.getTargetWidth() || this.vertexMap.getNumTilesHigh() <= this.generationParams.getTargetHeight()) {
            this.vertexMap = this.midpointDisplacement.doubleSize(this.vertexMap);
            this.heightmapVariance *= this.generationParams.getHeightMapRoughness();
            this.midpointDisplacement.applyDiamondSquareToPredoubled(this.vertexMap, this.heightmapVariance, this.random);
            this.vertexMap.normalise();
        } else {
            this.heightMap = this.vertexMap.toHeightMap();
        }
    }

    private void initialiseOreGeneration() {
        this.totalMapSize = this.generationParams.getTargetWidth() * this.generationParams.getTargetHeight();
        long minUsefulRegionSize = Math.round(0.001 * (double)this.totalMapSize);
        this.largeMountainRegions = new ArrayList<MapRegion>();
        this.totalMountainTiles = 0;
        for (MapRegion region : this.gameMap.getRegions().values()) {
            if (!region.getTileType().equals((Object)TileType.MOUNTAIN) || (long)region.size() <= minUsefulRegionSize) continue;
            this.largeMountainRegions.add(region);
            this.totalMountainTiles += region.size();
        }
        this.amountOreRequired = (int)Math.ceil((float)this.totalMountainTiles * this.generationParams.getRequiredTotalOreRatio());
        this.amountOreGenerated = 0;
        this.amountGemsRequired = (int)Math.ceil((float)this.totalMountainTiles * this.generationParams.getRequiredTotalGemRatio());
        this.amountGemsGenerated = 0;
    }

    private void generateGems() {
        int requestedVeinLength = 2 + this.random.nextInt(3);
        float veinThickness = 1.0f + this.random.nextFloat() * 2.0f;
        float veinWidthVariance = 0.3f;
        BinaryGrid veinGrid = this.oreVeinGenerator.generate(requestedVeinLength, veinThickness, veinWidthVariance, this.random);
        MapRegion regionToUse = this.pickRegion(this.largeMountainRegions, this.totalMountainTiles);
        GridPoint2 randomPointInRegion = this.randomPointIn(regionToUse);
        GridPoint2 startPoint = randomPointInRegion.cpy().sub(veinGrid.getWidth() / 2, veinGrid.getHeight() / 2);
        GemType getToUse = this.pickGemToGenerate(this.gameMap.get(randomPointInRegion));
        for (int x = 0; x < veinGrid.getWidth(); ++x) {
            for (int y = 0; y < veinGrid.getHeight(); ++y) {
                boolean gemRequired = veinGrid.get(x, y);
                if (!gemRequired) continue;
                GridPoint2 mapPoint = startPoint.cpy().add(x, y);
                GameMapTile mapTile = this.gameMap.get(mapPoint.x, mapPoint.y);
                if (mapTile == null || !mapTile.getTileType().equals((Object)TileType.MOUNTAIN)) continue;
                mapTile.setGem(getToUse, this.random);
                ++this.amountGemsGenerated;
            }
        }
    }

    private void generateOre() {
        int requestedVeinLength = this.random.nextInt(this.generationParams.getMaxOreVeinLength() - this.generationParams.getMinOreVeinLength()) + this.generationParams.getMinOreVeinLength();
        float veinThickness = this.random.nextFloat() * (float)(this.generationParams.getMaxOreVeinLength() - this.generationParams.getMinOreVeinLength()) / 4.0f;
        veinThickness = Math.max(veinThickness, (float)requestedVeinLength / 5.0f);
        float veinWidthVariance = veinThickness * this.random.nextFloat() / 2.0f;
        veinWidthVariance += this.random.nextFloat() * veinWidthVariance * 2.0f - 1.0f;
        veinWidthVariance = Math.max(veinWidthVariance, 1.0f);
        BinaryGrid oreGrid = this.oreVeinGenerator.generate(requestedVeinLength, veinThickness, veinWidthVariance, this.random);
        MapRegion regionToUse = this.pickRegion(this.largeMountainRegions, this.totalMountainTiles);
        GridPoint2 randomPointInRegion = this.randomPointIn(regionToUse);
        GridPoint2 startPoint = randomPointInRegion.cpy().sub(oreGrid.getWidth() / 2, oreGrid.getHeight() / 2);
        OreType oreToUse = this.pickOreToGenerate(this.gameMap.get(randomPointInRegion));
        for (int x = 0; x < oreGrid.getWidth(); ++x) {
            for (int y = 0; y < oreGrid.getHeight(); ++y) {
                boolean oreRequired = oreGrid.get(x, y);
                if (!oreRequired) continue;
                GridPoint2 mapPoint = startPoint.cpy().add(x, y);
                GameMapTile mapTile = this.gameMap.get(mapPoint.x, mapPoint.y);
                if (mapTile == null || !mapTile.getTileType().equals((Object)TileType.MOUNTAIN)) continue;
                mapTile.setOre(oreToUse, this.random);
                ++this.amountOreGenerated;
            }
        }
    }

    private GridPoint2 randomPointIn(MapRegion regionToUse) {
        GridPoint2 randomPoint = null;
        while (randomPoint == null) {
            randomPoint = new GridPoint2(this.random.nextInt(regionToUse.getMaxX() - regionToUse.getMinX()) + regionToUse.getMinX(), this.random.nextInt(regionToUse.getMaxY() - regionToUse.getMinY()) + regionToUse.getMinY());
            GameMapTile randomTile = this.gameMap.get(randomPoint.x, randomPoint.y);
            if (randomTile == null || randomTile.getRegion().equals(regionToUse)) continue;
            randomPoint = null;
        }
        return randomPoint;
    }

    private MapRegion pickRegion(List<MapRegion> largeMountainRegions, int totalMountainTiles) {
        Iterator<MapRegion> iterator = largeMountainRegions.iterator();
        MapRegion regionToUse = null;
        for (int regionPicker = this.random.nextInt(totalMountainTiles); regionPicker >= 0; regionPicker -= regionToUse.size()) {
            regionToUse = iterator.next();
        }
        return regionToUse;
    }

    private OreType pickOreToGenerate(GameMapTile gameMapTile) {
        List<OreType> oreTypeList = gameMapTile.getRockType().getOreTypes();
        float totalWeighting = 0.0f;
        for (OreType oreType : oreTypeList) {
            totalWeighting += oreType.getWeighting();
        }
        OreType oreToUse = null;
        Iterator<OreType> iterator = oreTypeList.iterator();
        for (float orePicker = this.random.nextFloat() * totalWeighting; orePicker >= 0.0f; orePicker -= oreToUse.getWeighting()) {
            oreToUse = iterator.next();
        }
        return oreToUse;
    }

    private GemType pickGemToGenerate(GameMapTile gameMapTile) {
        List<GemType> gemTypes = this.generationParams.getGemTypes(gameMapTile.getRockGroup());
        float totalWeighting = 0.0f;
        for (GemType gemType : gemTypes) {
            totalWeighting += gemType.getWeighting();
        }
        GemType gemToUse = null;
        Iterator<GemType> iterator = gemTypes.iterator();
        for (float orePicker = this.random.nextFloat() * totalWeighting; orePicker >= 0.0f && iterator.hasNext(); orePicker -= gemToUse.getWeighting()) {
            gemToUse = iterator.next();
        }
        return gemToUse;
    }

    public AbstractGameMap getCurrentMap() {
        if (this.gameMap != null) {
            return this.gameMap;
        }
        if (this.heightMap != null) {
            return this.heightMap;
        }
        return this.vertexMap;
    }

    public boolean isFinished() {
        return this.finished;
    }
}

